checkMarksOK <- function(mikes) {
if(!requireNamespace("spatstat.geom")) {
    stop("Required package spatstat.geom is not available.\n")
}
numMrks <- function(x){inherits(spatstat.geom::marks(x),"numeric")}
facMrks <- function(x){inherits(spatstat.geom::marks(x),"factor")}
isnum   <- sapply(mikes,numMrks)
if(all(isnum)) {
    ok <- TRUE
} else {
    isfac <- sapply(mikes,facMrks)
    if(all(isfac)) {
        lvls <- lapply(mikes,function(x){levels(marks(x))})
        nlvls <- sapply(lvls,length)
        if(length(unique(nlvls)) != 1) {
            stop("The patterns have differing numbers of types.\n")
        }
        mlvls <- matrix(unlist(lvls),byrow=TRUE,nrow=length(mikes))
        dupes <- sum(duplicated(mlvls))
        if(dupes == nrow(mlvls)-1) {
            ok <- TRUE
        } else {
            stop("The patterns have differing types.\n")
        }
    } else {
        whinge <- paste0("Patterns have differing classes of marks or have",
                         " marks that are\n","  neither numeric nor factors.\n")
        stop(whinge)
    }
}
ok
}
