\encoding{UTF-8}
\name{bubbles}
\alias{bubbles}
\docType{data}
\title{
Flotation Bubble Data
}
\description{
A collection of point patterns of the locations of bubbles in a
mineral flotation experiment where the interest lies in analysing
whether the spatial distribution might be affected by frother
concentrations and volumetric airflow rates.
}
\usage{bubbles}
\format{
The object \code{bubbles} is a hyperframe with 1378 rows. It has a
column named \code{patterns}, of class \code{"pplist"}, containing
marked point patterns of bubble locations.  The marks are numeric,
consisting of the bubble diameters.  The object also has a column
named \code{FC} (specific \dQuote{frother concentration}) which is
a factor with levels 5, 10 and 15, and a column named \code{VA}
(\dQuote{volumetric airflow}) which is a factor with levels 5,
8 and 10.
}
\source{
This data set was kindly provided by Jorge Mateu, of the Department
of Mathematics, University Jaume I, \enc{Castellón}{Castellon},
Spain.
}
\references{
Two-way layout factorial experiments of spatial
point pattern responses in mineral flotation, 2021.
J. A. \enc{González}{Gonzalez}, B. M Lagos-Alvarez, and
J. Mateu.  \emph{TEST} \bold{30} pp. 768 -- 806.
DOI https://doi.org/10.1007/s11749-021-00768-w.
}
\examples{
if(requireNamespace("spatstat.geom")) {
    which.max(sapply(bubbles$patterns,spatstat.geom::npoints)) # 963
    spatstat.geom::plot.ppp(bubbles$patterns[[963]],
                        main="Largest bubbles pattern")
}
}
\keyword{datasets}
