\name{cnmlcd} \alias{cnmlcd}

%- Also NEED an '\alias' for EACH other topic documented here.

\title{ Maximum Likelihood Estimation of a Log-concave Density Function
}

\description{ The function computes the nonparametric maximum likelihood
estimate (NPMLE) of a log-concave density from univariate observations.
}

\usage{
cnmlcd(x, lcd, maxit = 100, tol = 1e-06,
       plot=c("null","density","logdensity","gradient"),
       verbose=0)
}
%- maybe also 'usage' for other objects documented here.

\arguments{

  \item{x}{ a vector storing univariate observations.  }

  \item{lcd}{ an initial log-concave density function, which is an
    object of class "lcd".  Inside the function, it will be examined and
    possibly adjusted to suit the given data, in particular the
    boundaries and interior knots. }

  \item{maxit}{ maximum number of iterations.  }

  \item{tol}{ tolerance level for stopping the algorithm. Internally, it
    is used as the threshold on the increase of the log-likelihood after
    each iteration. }

  \item{plot}{ type of a plot to be created in each iteration of the
    algorithm. If \code{"null"}, no plot is produced. Useful for
    monitoring the computing process.}

  \item{verbose}{ verbosity level for printing intermediate
     results. Useful for monitoring the computing process.}

}

\details{ The algorithm used to compute the NPMLE is an extension of the
  constrained Newton method of Wang (2007) for nonparametric mixture
  estimation. It guarantees to find the unique NPMLE.

  The algorithm is described in Liu and Wang (2018).
}

\value{ An object of class \code{cnmlcd}, which is a list with the
  following elements:
  
 \item{lcd}{the computed NPMLE, stored as an object of class "lcd".}
 
 \item{ll}{the log-likelihood value, evaluated at the NPMLE.}

 \item{num.iterations}{the number of iterations used.}

 \item{max.gradient}{the maximum gradient value of the estimate before the
   last iteration.}

 \item{convergence}{= 0, a successful convergence;

   = 1, the maximum number of iterations in the main loop is reached;

   = 2, not an ascent direction in line search;

   = 3, the maximum number of iterations is reached in line search.

 }

 }

\references{

  Wang, Y. (2007). On the fast computation of the nonparametric maximum
  likelihood estimate of a mixing distribution. Journal of the Royal
  Statistical Society, Series B, 69, 185-198.

  Liu, Y. and Wang, Y. (2018). A Fast Algorithm for Univariate
  Log-concave Density Estimation. \emph{Australia & New Zealand Journal
  of Statistics} (To appear).

}

\author{
  Yu Liu <liu.yu@auckland.ac.nz>, Yong Wang <yongwang@auckland.ac.nz>
}

%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{ \code{\link{lcd}}, \code{\link{new.lcd}}, \code{\link{dlcd}}, \code{\link{plcd}}. }

\examples{
## Normal density
x = rnorm(1000)
(r = cnmlcd(x))

## Log-likelihood values at the NPMLE
r$ll
logLik(r$lcd, x)

## Density, log density and gradient plot
plot(r)               # density, without data
plot(r, x)            # density, with data
plot(r, x, type="l")  # log density, with data
plot(r, x, type="g")  # gradient

## Probability and density function of the Log-concave distribution
plcd(-4:4, r$lcd)
dlcd(-4:4, r$lcd)

## Estimation from log-return data
data(logreturn)
r = cnmlcd(logreturn)
plot(r, logreturn)
plot(r, logreturn, type="l")

## Estimation for log-volatility data
data(logvolatility)
r = cnmlcd(logvolatility)
plot(r, logvolatility)
}
