\name{lcd.object}
\alias{lcd}
\alias{lcd.object}

\title{Class \code{lcd}}

\description{Class \code{lcd} is used to store a log-concave density
  function (f), where the log-density is given by a piecewise linear function.
}

\details{
  Given an \code{lcd} object, the density function is defined by \deqn{f(x; \alpha, \theta, \pi, L, U) = \frac{1}{C} e^{\alpha (x-L) - \sum_{j=1}^m \pi_j(x-\theta_j)_+},\ \ \ \mathrm{for\ } x \in [L, U],}{f(x; alpha, theta, pi, L, U) = 
  
   C^(-1) exp{alpha (x - L) - sum_{j=1}^m pi_j (x-theta_j)_+},

                                          for x in [L, U],} where \eqn{C}{C} is the normalizing constant given by \deqn{C = \int_L^U e^{\alpha (x - L) - \sum_{j=1}^m \pi_j (x-\theta_j)_+}\;dx.}{  C = Integral_L^U e^{alpha (x - L) - sum_{j=1}^m pi_j (x-theta_j)_+} dx.}

   An \code{lcd} object is fully defined by parameters \code{(alpha,
   theta, pi, L, U)}. Inside the object, \code{coef}, \code{fk},
   \code{dpk} and \code{cpk} are also stored, which though can all be
   worked out from the given parameters. They are computed when a new
   \code{lcd} object is created by function \code{new.lcd()} so as to
   facilitate computation when the object is used later.

 }
 
\value{

  A list consisting of:

  \item{alpha}{ the slope of the log-density before the first interior
    knot.  }
  
  \item{C}{the normalizing constant.}
  
  \item{theta}{vector of interior knots.}
  
  \item{pi}{ vector of changes of slope at the interior knots.  }
  
  \item{lower}{lower boundary knot (\eqn{L}). This should be the smallest
    observed value.}
  
  \item{upper}{upper boundary knot (\eqn{U}). This should be the largest
    observed value.}
  
  \item{coef}{a numeric matrix with two rows, with rows 1 and 2 storing,
  respectively, the intercepts and slopes of the log-density between
  knots.}

  \item{fk}{density values at the lower boundary (\code{lower}) and the
    interior knots (\code{theta}). }

  \item{dpk}{\eqn{\int x^o f(x) dx}{integral x^o f(x) dx} over the
    interval between a pair of neighbouring knots (boundary and
    interior) for \eqn{o = 0, 1, 2}.}
  
  \item{cpk}{\eqn{\int x^o f(x) dx}{integral x^o f(x) dx} over the
    interval between the lower boundary and each knot (including
    \code{upper}. }
  
}
\seealso{ \code{\link{cnmlcd}}, \code{\link{plcd}}, \code{\link{dlcd}}, \code{\link{new.lcd}}. }

