\name{plot.lcd}
\alias{plot.lcd}
\alias{plot.cnmlcd}

\title{
  Plot Log-concave Density
}
\description{
  Plot method for class "lcd".
}

\usage{
\method{plot}{lcd}(x, data, w=NULL, type=c("density","logdensity","gradient"),
   col="blue", knotcol=col, border="grey",
   lwd=1, lty=1, pch=1, main, breaks=50, ...)
\method{plot}{cnmlcd}(x, ...)

}

\arguments{
  
  \item{x}{
    an object of class \code{lcd} or class \code{cnmlcd}.
  }
  
  \item{data}{
    a numeric vector storing the observations.
  }
  
  \item{w}{
    frequencies or weights for the values in \code{x}. If NULL, \code{w
    = 1} is used for each value in \code{x}. 
  }
  
  \item{type}{one of "density","logdensity" and"gradient". The specified
    type of function will be ploted. }
  
  \item{col}{ color of lines.  }
  
  \item{knotcol}{ color of knots.  }
  
  \item{border}{ color for the border of histogram or log histogram.  }
  
  \item{lwd}{ line width.  }
  
  \item{lty}{ line type.  }
  
  \item{pch}{ point type used for knots.  }
  
  \item{main}{ main title.  }
  
  \item{breaks}{ number of break points used for creating histogram or log-histogram.  }
  
  \item{...}{further arguments passed to or from other methods.  }

}

\details{ The density, its logarithm or gradient function is plotted,
  depending on the value of \code{type}. Knots are shown in points. If
  \code{data} is provided, the density or log density plot also includes
  a histgram or log-histogram for \code{data}.

  \code{plot.cnmlcd} is a wrapper function for \code{plot.lcd}, where
  its \code{lcd} object is passed as the first argument to
  \code{plot.lcd}. Other arguments specified by \code{...} are all
  passed to \code{plot.lcd}.

}

\references{

  Liu, Y. and Wang, Y. (2018). A Fast Algorithm for Univariate
  Log-concave Density Estimation. \emph{Australia & New Zealand Journal
  of Statistics} (To appear).
  
}

\author{
  Yu Liu <liu.yu@auckland.ac.nz>, Yong Wang <yongwang@auckland.ac.nz>
}

\seealso{ \code{\link{cnmlcd}}, \code{\link{lcd}},
  \code{\link{new.lcd}}, \code{\link{dlcd}}. }
