## Box-Cox transformation

bct = function(data, lambda1=-20:20/5, lambda2f=2^(-10:10/2)) {
  if(is.vector(data)) {v = TRUE; data = as.matrix(data)} else v = FALSE
  ## if(!is.matrix(data)) data = as.matrix(data)
  n = nrow(data)
  m = ncol(data)
  data.bc = data
  opt = matrix(nrow=2, ncol=m)    # optimal lambda
  lambda = expand.grid(lambda1, lambda2f)
  k = nrow(lambda)
  rho = double(k)
  for(j in 1:m) {
    x = sort(data[,j])
    s = sd(x)
    x1 = min(x)
    lambda2 = - x1 + lambda[,2] * s
    for(l in 1:k) {
      if(lambda[l,1] == 0) y = log(x + lambda2[l])
      else y = ((x + lambda2[l])^lambda[l,1] - 1) / lambda[l,1]
      rho[l] = cor(y, qnorm(1:n/(n+1)))
      ## rho[l] = cor(y, qnorm((1:n-0.5)/n))
    }
    jmax = which.max(rho)
    opt[,j] = c(lambda[jmax,1], lambda2[jmax])
    if(opt[j] == 0) data.bc[,j] = log(data[,j] + opt[2,j])
    else data.bc[,j] = ((data[,j] + opt[2,j])^opt[1,j] - 1) / opt[1,j]
  }
  if(v) data.bc = as.vector(data.bc)
  attr(data.bc, "lambda") = opt
  data.bc
}

